/*
 * json_utils.h
 *
 *  
 *      
 */

#ifndef JSON_UTILS_op_H_
#define JSON_UTILS_op_H_

//#define   _NEW
#include "json.h"
//#undef _NEW

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include <stl_pif.h>

class json_utils {
public:
	json_utils();
	~json_utils();

	tBool getJSONObject(Json::Value& input, tCString jsonObjName, Json::Value& output);
	tBool getJSONArray(Json::Value& input, tCString jsonObjName, Json::Value& output);
	tBool getString(Json::Value& input, tCString name, std::string& output);
	tBool gettBool(Json::Value& input, tCString jsonObjName, tBool& output);
	tBool gettU8UInt(Json::Value& input, tCString jsonObjName, tU8& output);
	tBool gettU16UInt(Json::Value& input, tCString jsonObjName, tU16& output);
	tBool gettU32UInt(Json::Value& input, tCString jsonObjName, tU32& output);
	tBool gettU64UInt(Json::Value& input, tCString jsonObjName, tU64& output);
	tBool getDouble(Json::Value& input, tCString jsonObjName, double& output);
	tBool getFloat(Json::Value& input, tCString jsonObjName, float& output);
	static const char* concat05Strings(const char* str1, const char* str2, const char* str3, const char* str4, const char* str5);
	static tVoid setTypePOIName(tCString type);
	static tVoid setTypePOINumber(tCString number);
	static tVoid concatPOIName();
	static tVoid resetPOIName();

	//Presoak ApplicationHeader
	static tCString PRESOAK_CALENDAR_UPLOAD_FUNC_ID;
	static tCString PRESOAK_CALENDAR_CORELATION_ID;
	static tCString PRESOAK_CALENDAR_USER_ID;
	static tCString PRESOAK_CALENDAR_TOKEN_ID;

	//Presoak ApplicationData
	static tCString PRESOAK_CALENDAR_TIMESTAMP_START;
	static tCString PRESOAK_CALENDAR_LASTSYNCTIMESTAMP;
	static tCString PRESOAK_CALENDAR_TIMESTAMP_END;
	static tCString PRESOAK_CALENDAR_TEMPVALUE_MMI;

	//Presoak ApplicationData V-Next To A-IVI
	static tCString PRESOAK_CALENDAR_NEWSYNCTIMESTAMP;
	static tCString PRESOAK_CALENDAR_STATUS;
	static tCString PRESOAK_CALENDAR_ERRORCODE;

	//Preosak ApplicationData: Calendar1 data
	static tCString PRESOAK_CALENDAR1_ACTIVATIONSTATE;
	static tCString PRESOAK_CALENDAR1_ARRIVALHOUR;
	static tCString PRESOAK_CALENDAR1_ARRIVALMINUTE;
	static tCString PRESOAK_CALENDAR1_MONDAY;
	static tCString PRESOAK_CALENDAR1_TUESDAY;
	static tCString PRESOAK_CALENDAR1_WEDNESDAY;
	static tCString PRESOAK_CALENDAR1_THURSDAY;
	static tCString PRESOAK_CALENDAR1_FRIDAY;
	static tCString PRESOAK_CALENDAR1_SATURDAY;
	static tCString PRESOAK_CALENDAR1_SUNDAY;

	//Preosak ApplicationData: Calendar2 data
	static tCString PRESOAK_CALENDAR2_ACTIVATIONSTATE;
	static tCString PRESOAK_CALENDAR2_ARRIVALHOUR;
	static tCString PRESOAK_CALENDAR2_ARRIVALMINUTE;
	static tCString PRESOAK_CALENDAR2_MONDAY;
	static tCString PRESOAK_CALENDAR2_TUESDAY;
	static tCString PRESOAK_CALENDAR2_WEDNESDAY;
	static tCString PRESOAK_CALENDAR2_THURSDAY;
	static tCString PRESOAK_CALENDAR2_FRIDAY;
	static tCString PRESOAK_CALENDAR2_SATURDAY;
	static tCString PRESOAK_CALENDAR2_SUNDAY;

	//Preosak ApplicationData: Calendar3 data
	static tCString PRESOAK_CALENDAR3_ACTIVATIONSTATE;
	static tCString PRESOAK_CALENDAR3_ARRIVALHOUR;
	static tCString PRESOAK_CALENDAR3_ARRIVALMINUTE;
	static tCString PRESOAK_CALENDAR3_MONDAY;
	static tCString PRESOAK_CALENDAR3_TUESDAY;
	static tCString PRESOAK_CALENDAR3_WEDNESDAY;
	static tCString PRESOAK_CALENDAR3_THURSDAY;
	static tCString PRESOAK_CALENDAR3_FRIDAY;
	static tCString PRESOAK_CALENDAR3_SATURDAY;
	static tCString PRESOAK_CALENDAR3_SUNDAY;

	//Preosak ApplicationData: Calendar4 data
	static tCString PRESOAK_CALENDAR4_ACTIVATIONSTATE;
	static tCString PRESOAK_CALENDAR4_ARRIVALHOUR;
	static tCString PRESOAK_CALENDAR4_ARRIVALMINUTE;
	static tCString PRESOAK_CALENDAR4_MONDAY;
	static tCString PRESOAK_CALENDAR4_TUESDAY;
	static tCString PRESOAK_CALENDAR4_WEDNESDAY;
	static tCString PRESOAK_CALENDAR4_THURSDAY;
	static tCString PRESOAK_CALENDAR4_FRIDAY;
	static tCString PRESOAK_CALENDAR4_SATURDAY;
	static tCString PRESOAK_CALENDAR4_SUNDAY;

	//Preosak ApplicationData: Calendar5 data
	static tCString PRESOAK_CALENDAR5_ACTIVATIONSTATE;
	static tCString PRESOAK_CALENDAR5_ARRIVALHOUR;
	static tCString PRESOAK_CALENDAR5_ARRIVALMINUTE;
	static tCString PRESOAK_CALENDAR5_MONDAY;
	static tCString PRESOAK_CALENDAR5_TUESDAY;
	static tCString PRESOAK_CALENDAR5_WEDNESDAY;
	static tCString PRESOAK_CALENDAR5_THURSDAY;
	static tCString PRESOAK_CALENDAR5_FRIDAY;
	static tCString PRESOAK_CALENDAR5_SATURDAY;
	static tCString PRESOAK_CALENDAR5_SUNDAY;

	//Charge ApplicationHeader
	static tCString CHARGE_CALENDAR_UPLOAD_FUNC_ID;
	static tCString CHARGE_CALENDAR_CORELATION_ID;
	static tCString CHARGE_CALENDAR_USER_ID;
	static tCString CHARGE_CALENDAR_TOKEN_ID;

	//Charge ApplicationData V-Next To A-IVI
	static tCString CHARGE_CALENDAR_NEWSYNCTIMESTAMP;
	static tCString CHARGE_CALENDAR_STATUS;
	static tCString CHARGE_CALENDAR_ERRORCODE;

	//Charge ApplicationData
	static tCString CHARGE_CALENDAR_TIMESTAMP_START;
	static tCString CHARGE_CALENDAR_LASTSYNCTIMESTAMP;
	static tCString CHARGE_CALENDAR_TIMESTAMP_END;
	static tCString CHARGE_CALENDAR_PROGRAMMED_STATUS;
	static tCString CHARGE_CALENDAR_DELAYED_VALUE;

	//Charge ApplicationData: Calendar1 data
	static tCString CHARGE_CALENDAR1_ACTIVATIONSTATE;
	static tCString CHARGE_CALENDAR1_BEGINHOUR;
	static tCString CHARGE_CALENDAR1_BEGINMINUTE;
	static tCString CHARGE_CALENDAR1_DURATION;
	static tCString CHARGE_CALENDAR1_MONDAY;
	static tCString CHARGE_CALENDAR1_TUESDAY;
	static tCString CHARGE_CALENDAR1_WEDNESDAY;
	static tCString CHARGE_CALENDAR1_THURSDAY;
	static tCString CHARGE_CALENDAR1_FRIDAY;
	static tCString CHARGE_CALENDAR1_SATURDAY;
	static tCString CHARGE_CALENDAR1_SUNDAY;

	//Charge ApplicationData: Calendar2 data
	static tCString CHARGE_CALENDAR2_ACTIVATIONSTATE;
	static tCString CHARGE_CALENDAR2_BEGINHOUR;
	static tCString CHARGE_CALENDAR2_BEGINMINUTE;
	static tCString CHARGE_CALENDAR2_DURATION;
	static tCString CHARGE_CALENDAR2_MONDAY;
	static tCString CHARGE_CALENDAR2_TUESDAY;
	static tCString CHARGE_CALENDAR2_WEDNESDAY;
	static tCString CHARGE_CALENDAR2_THURSDAY;
	static tCString CHARGE_CALENDAR2_FRIDAY;
	static tCString CHARGE_CALENDAR2_SATURDAY;
	static tCString CHARGE_CALENDAR2_SUNDAY;

	//Charge ApplicationData: Calendar3 data
	static tCString CHARGE_CALENDAR3_ACTIVATIONSTATE;
	static tCString CHARGE_CALENDAR3_BEGINHOUR;
	static tCString CHARGE_CALENDAR3_BEGINMINUTE;
	static tCString CHARGE_CALENDAR3_DURATION;
	static tCString CHARGE_CALENDAR3_MONDAY;
	static tCString CHARGE_CALENDAR3_TUESDAY;
	static tCString CHARGE_CALENDAR3_WEDNESDAY;
	static tCString CHARGE_CALENDAR3_THURSDAY;
	static tCString CHARGE_CALENDAR3_FRIDAY;
	static tCString CHARGE_CALENDAR3_SATURDAY;
	static tCString CHARGE_CALENDAR3_SUNDAY;

	//Charge ApplicationData: Calendar4 data
	static tCString CHARGE_CALENDAR4_ACTIVATIONSTATE;
	static tCString CHARGE_CALENDAR4_BEGINHOUR;
	static tCString CHARGE_CALENDAR4_BEGINMINUTE;
	static tCString CHARGE_CALENDAR4_DURATION;
	static tCString CHARGE_CALENDAR4_MONDAY;
	static tCString CHARGE_CALENDAR4_TUESDAY;
	static tCString CHARGE_CALENDAR4_WEDNESDAY;
	static tCString CHARGE_CALENDAR4_THURSDAY;
	static tCString CHARGE_CALENDAR4_FRIDAY;
	static tCString CHARGE_CALENDAR4_SATURDAY;
	static tCString CHARGE_CALENDAR4_SUNDAY;

	//Charge ApplicationData: Calendar5 data
	static tCString CHARGE_CALENDAR5_ACTIVATIONSTATE;
	static tCString CHARGE_CALENDAR5_BEGINHOUR;
	static tCString CHARGE_CALENDAR5_BEGINMINUTE;
	static tCString CHARGE_CALENDAR5_DURATION;
	static tCString CHARGE_CALENDAR5_MONDAY;
	static tCString CHARGE_CALENDAR5_TUESDAY;
	static tCString CHARGE_CALENDAR5_WEDNESDAY;
	static tCString CHARGE_CALENDAR5_THURSDAY;
	static tCString CHARGE_CALENDAR5_FRIDAY;
	static tCString CHARGE_CALENDAR5_SATURDAY;
	static tCString CHARGE_CALENDAR5_SUNDAY;

	//PreSoak A-IVI to VNext AIVISynchroAck ApplicationHeader
	static tCString PRESOAK_SYNCHRO_ACK_UPLOAD_FUNC_ID;
	static tCString PRESOAK_SYNCHRO_ACK_CORELATION_ID;
	static tCString PRESOAK_SYNCHRO_ACK_USER_ID;
	static tCString PRESOAK_SYNCHRO_ACK_TOKEN_ID;

	//PreSoak A-IVI to VNext AIVISynchroAck Data
	static tCString PRESOAK_SYNCHRO_ACK_TIMESTAMP;
	static tCString PRESOAK_SYNCHRO_ACK_NEWSYNCTIMESTAMP;
	static tCString PRESOAK_SYNCHRO_ACK_STATUS;
	static tCString PRESOAK_SYNCHRO_ACK_ERRORCODE;

	//PreSoak A-IVI to VNext AIVISynchroNeededAck ApplicationHeader
	static tCString PRESOAK_SYNCHRO_NEEDED_ACK_UPLOAD_FUNC_ID;
	static tCString PRESOAK_SYNCHRO_NEEDED_ACK_CORELATION_ID;
	static tCString PRESOAK_SYNCHRO_NEEDED_ACK_USER_ID;
	static tCString PRESOAK_SYNCHRO_NEEDED_ACK_TOKEN_ID;

	//PreSoak A-IVI to VNext AIVISynchroNeededAck Data
	static tCString PRESOAK_SYNCHRO_NEEDED_ACK_TIMESTAMP;
	static tCString PRESOAK_SYNCHRO_NEEDED_ACK_STATUS;
	static tCString PRESOAK_SYNCHRO_NEEDED_ACK_ERRORCODE;

	//PreSoak VNext to A-IVI AVNextSynchroNeeded Data
	static tCString PRESOAK_NEXT_SYNCHRO_NEEDED_TIMESTAMP;

	//Charge A-IVI to VNext AIVISynchroAck ApplicationHeader
	static tCString CHARGE_SYNCHRO_ACK_UPLOAD_FUNC_ID;
	static tCString CHARGE_SYNCHRO_ACK_CORELATION_ID;
	static tCString CHARGE_SYNCHRO_ACK_USER_ID;
	static tCString CHARGE_SYNCHRO_ACK_TOKEN_ID;

	//PreSoak A-IVI to VNext AIVISynchroAck Data
	static tCString CHARGE_SYNCHRO_ACK_TIMESTAMP;
	static tCString CHARGE_SYNCHRO_ACK_NEWSYNCTIMESTAMP;
	static tCString CHARGE_SYNCHRO_ACK_STATUS;
	static tCString CHARGE_SYNCHRO_ACK_ERRORCODE;

	//Charge A-IVI to VNext AIVISynchroNeededAck ApplicationHeader
	static tCString CHARGE_SYNCHRO_NEEDED_ACK_UPLOAD_FUNC_ID;
	static tCString CHARGE_SYNCHRO_NEEDED_ACK_CORELATION_ID;
	static tCString CHARGE_SYNCHRO_NEEDED_ACK_USER_ID;
	static tCString CHARGE_SYNCHRO_NEEDED_ACK_TOKEN_ID;

	//Charge A-IVI to VNext AIVISynchroNeededAck Data
	static tCString CHARGE_SYNCHRO_NEEDED_ACK_TIMESTAMP;
	static tCString CHARGE_SYNCHRO_NEEDED_ACK_STATUS;
	static tCString CHARGE_SYNCHRO_NEEDED_ACK_ERRORCODE;

	//Charge VNext to A-IVI AVNextSynchroNeeded Data
	static tCString CHARGE_NEXT_SYNCHRO_NEEDED_TIMESTAMP;

	//ApplicationHeader: File Header JSON object names
	static tCString APPLICATIONHEADER;
	static tCString DATADICTIONARYVERSION;

	static tCString MESSAGETYPE;//long lablel
	static tCString MSGTYPE;//short lablel

	static tCString TARGETID;//long lablel
	static tCString TID;//short lablel

	static tCString DEVID;
	static tCString DEVICETYPE;
	static tCString VIN;
	static tCString BIN;
	static tCString TIMESTAMP;
	static tCString TS;

	static tCString CORRELATIONID;//long lablel
	static tCString CID;//short lablel

	static tCString GLOBALMESSAGEID;//long lablel
	static tCString GID;//short lablel

    static tCString USER_ID;
	static tCString TOKEN;

	//ApplicationData: Data JSON object name
	static tCString VERSION;
	static tCString DCMVERSION;

	//static tCString TIMESTAMP;
	static tCString DATAWIPE_DATA_ACTION;

	//UpLoadData from clients
	static tCString UPLOADHEADER;
	static tCString UPLOADFUNCTIONID;
	static tCString UPLOADDATA;
	// For DownLoad and UpLoad ConfigPolicy

	//DownLoad
	static tCString DBMAPDOWNLOAD;
	static tCString DOWNLOAD;
	static tCString DRMDATAREQTIMEOUT;
	static tCString GIDLISTMAX;

	//Upload
	static tCString DBMAPUPLOAD;
	static tCString UPLOAD;
	static tCString UPLOADTOPIC;
	static tCString TOPICNAME;

	//Common of ConfigPolicy
	static tCString BUFFERSTYPE;
	static tCString DBPRIO;
	static tCString BUFFERS;
	static tCString QUEUESIZE;
	static tCString QUEUELENGTH;

	//UploadFunction
	static tCString UPLOADFUNCTION;

	//Signal Map DownLoad
	static tCString SIGNALMAPDOWNLOAD;
	static tCString SIGNAL;

	//GenGlobalMessageId
	static tCString GENGLOBALMESSAGEID;

	//Data Dictionary
	static tCString DATADICTIONARY;
	static tCString LONGLABEL;
	static tCString SHORTLABEL;

	//DataWipe
	static tCString DATAWIPE;

	static tCString DWASTA;
	static tCString DATAWIPE_DATA_STATUS;
	static tCString DWAEC;

	static tCString DATAWIPE_DATA_ERRORCODE;

	//LogTrace
	static tCString LOGTRACE;

	//LabelConvert
	static tCString LABELCONVERT;

	//Mqtt Configuration needs
	static tCString MQTT;
	static tCString DRM;
	static tCString MQTTCONFIGPOLICY;
	static tCString MQTTSESSIONTYPE;
	static tCString MQTTKEEPTIMEALIVE;

	static tCString KEEPALIVE;
	static tCString INTERVAL;
	static tCString USERNAME;
	static tCString PASSWORD;
	static tCString OCCURRENCE;
	static tCString TIMEOUT;
	static tCString CLEANSESSION;
	static tCString DELAY;

	static tCString MQTTPERIODICCONNECTINTERVAL;
	static tCString MQTTPAYLOADCOMPRESSION;
	static tCString MQTTUSERNAMECONFIG;
	static tCString MQTTPASSWORDCONFIG;
	static tCString URL;
	static tCString PORT;
	static tCString MQTTRETRYCONNECTINTERVAL;
	static tCString MQTTRETRYCONNECTOCCURRENCE;
	static tCString MQTTRETRYPUBLISHINTERVAL;
	static tCString MQTTRETRYPUBLISHOCCURRENCE;
	static tCString MQTTRETRYSUBSCRIBEINTERVAL;
	static tCString MQTTRETRYSUBSCRIBEOCCURRENCE;
	static tCString MQTTCONNECTIONTIMEOUT;
	static tCString MQTTSUBSCRIPTIONTIMEOUT;
	static tCString MQTTPUBLISHTIMEOUT;
	static tCString MQTTCLEANSWITCHTOZLIB;
	static tCString MQTTCLEANSWITCHFROMZLIB;
	static tCString TLS_EXPBACKOFFSTARTDELAY;

	static tCString TLS;
	//Dummy Download and Upload topics
	static tCString MQTTDOWNLOADTOPIC_01;
	static tCString MQTTDOWNLOADTOPIC_02;
	static tCString MQTTDOWNLOADTOPIC_03;
	static tCString MQTTDOWNLOADTOPIC_04;

	static tCString MQTTUPLOADTOPIC_DEFAULT;
	static tCString MQTTUPLOADTOPIC_01;
	static tCString MQTTUPLOADTOPIC_02;
	static tCString MQTTUPLOADTOPIC_03;
	static tCString MQTTUPLOADTOPIC_04;
	static tCString MQTTUPLOADTOPIC_05;

	//POI Data Original
	static tCString DOWNLOADTRAFFICINFOORG;
	static tCString DOWNLOADTRAFFICINFOORG_SHORT;

	static tCString NAMEORG;
	static tCString NAMEORG_SHORT;

	static tCString TTSORG;
	static tCString TTSORG_SHORT;

	static tCString ADDRESSORG;
	static tCString ADDRESSORG_SHORT;

	static tCString PHONENUMBERORG;
	static tCString PHONENUMBERORG_SHORT;

	static tCString LATITUDEORG;
	static tCString LATITUDEORG_SHORT;

	static tCString LONGITUDEORG;
	static tCString LONGITUDEORG_SHORT;

	static tCString LATITUDEMODEORG;
	static tCString LATITUDEMODEORG_SHORT;

	static tCString LONGITUDEMODEORG;
	static tCString LONGITUDEMODEORG_SHORT;

	static tCString LOCATIONTYPEORG;
	static tCString LOCATIONTYPEORG_SHORT;

	static tCString CALCULATIONCONDITIONORG;
	static tCString CALCULATIONCONDITIONORG_SHORT;

	//POI data
	static tCString APPLICATIONDATA;

	static tCString TYPECALL;
	static tCString TYPENO;

	static tCString DOWNLOADTRAFFICINFO;
	static tCString DOWNLOADTRAFFICINFO_SHORT;

	static tCString NAME;
	static tCString NAME_SHORT;

	static tCString TTS;
	static tCString TTS_SHORT;

	static tCString ADDRESS;
	static tCString ADDRESS_SHORT;

	static tCString PHONENUMBER;
	static tCString PHONENUMBER_SHORT;

	static tCString LATITUDE;
	static tCString LATITUDE_SHORT;

	static tCString LONGITUDE;
	static tCString LONGITUDE_SHORT;

	static tCString LATITUDEMODE;
	static tCString LATITUDEMODE_SHORT;

	static tCString LONGITUDEMODE;
	static tCString LONGITUDEMODE_SHORT;

	static tCString LOCATIONTYPE;
	static tCString LOCATIONTYPE_SHORT;

	static tCString CALCULATIONCONDITION;
	static tCString CALCULATIONCONDITION_SHORT;

	static tCString PREFIX_SHORT;
	static tCString CALLTYPE_SHORT;
	static tCString POITYPE;
	static tCString CALLTYPE;
	static tCString CALLSENT;

	//EV Private items
	static tCString EV;
	static tCString CHARGE_SCHEDULER_ACTIVATION;
	static tCString STATUS;
	static tCString PRESOAK_SCHEDULER_ACTIVATION;

};

#endif /* JSON_UTILS_H_ */
